import { User } from "src/framework";
import { DashboardTO, HistoryTender, HistoryTenderDetail, InsertTender, ParamsNotificationTO, Tender } from "src/licitaapp/domain";
import { ApplicationTypeEnum } from "src/licitaapp/domain/enum/enum.definition";

export interface TenderService {
    /**
     * Agrega una licitacion a la empresa.
     * @param code -° Codigo de la licitacion.
     * @param companyId  -° Id de la empresa.
     * @returns Mensaje de resultado.
     */
    addTenderByCodeToCompany(code: string, companyId: number): Promise<string>;
    /**
     * Establece la fecha de cierre de las licitaciones que no la tienen.
     * @param applicationLogId -° Trackung de DB.
     * @returns Mensaje de resultado.
     */
    checkCloseDate(applicationLogId: number): Promise<string>;
    /**
     * Revisa la tabla Keyword y completa la metadata de coincidencias nuevas
     * @param applicationLogId -° Trackung de DB.
     */
    checkMetadataKeywords(applicationLogId: number): Promise<string>;
    /**
     * Busca licitaciones a todas las empresas activas y con usuarios asociados.
     * @param applicationLogId 
     */
    checkNewTendersUserCompany(applicationLogId: number): Promise<string>;
    /**
     * Busca licitaciones que esten por cerrarse y que cumplan con los dias del parametro TENDERS_LIMIT_DAYS
     * @param applicationLogId 
     */
    checkTenderFavoritesToClose(applicationLogId: number): Promise<string>;
    /**
     * Revisa licitaciones con fecha de cierre y las elimina logicamente del sistema.
     * @param applicationLogId -> Trackung de DB.
     * @returns Mensaje de resultado.
     */
    checkTenderWithCloseDate(applicationLogId: number): Promise<string>;
    /**
     * Busca licitaciones sin subdivision y las completa con la ciudad correspondiente.
     * @param applicationLogId 
     */
    checkTenderSubdivision(applicationLogId: number): Promise<string>;
    /**
     * Evento que se gatilla cuando se crea una empresa desde la App.
     * @param companyId 
     * @param userId 
     */
    createDashboardCompany(companyId: number, userId: number): Promise<void>;
    /**
     * Busca topicos, palabras y metadata de textos.
     * @param textToEval 
     */
    fetchRazorMetadata(textToEval: string): Promise<any>;
    /**
     * Entrega el resumen de la dashboard de la empresa.
     * @param user 
     * @param companyId 
     */
    generateInfoDashboard(user: User, companyId: number): Promise<DashboardTO>;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, subdivisionId: number, monthRequest: string): Promise<Tender[]>;
    getTenderByCode(code: string, userId?: number): Promise<Tender | undefined>;
    
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    
    /**
     * Borron y cuenta nueva y asocia licitaciones a todos los usuarios de Licitaapp
     * @param applicationLogId 
     */
    recalculteTender(applicationLogId: number): Promise<string>;
    reviewTendersInfo(action: ApplicationTypeEnum): Promise<void>;
    /**
     * Revisa si el estado de la licitacion ha cambiado y actualiza el estado.
     * @param applicationLogId 
     */
    reviewTenderStatus(applicationLogId: number): Promise<string>;
    reviewTenderWihoutMetadata(applicationLogId: number): Promise<string>;
    searchTendersDB(params: ParamsNotificationTO, waitMinutes?: boolean): Promise<String>;
    searchTenderToUserCompanyWithSubdivision(companyId: number, userId: number): Promise<void>;
    
    /**
     * Metodo que se ejecuta cada 5 minutos para realizar tareas.
     */
    tenderTaskEvery5Minutes(): Promise<void>;
    /**
     * Metodo concetrador de tareas que se ejecutan cada minuto
     */
    tenderTaskPerMinutes(): Promise<void>;
    /**
     * Metodo concentrador que se ejecuta cada 2 horas.
     */
    tenderTaskBy2Hour(): Promise<void>;
    /**
     * Metodo que se 1 vez al dia.
     */
    tenderTaskPerDay(): Promise<void>;
    /**
     * Metodo concentrador que se ejecuta cada hora.
     */
    tenderTaskByHour(): Promise<void>;
    updateFavoriteUserCompanytender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    /**
     * Borra toda información de licitaciones eliminadas  del sistema (deleted true).
     */
    erraseOldTenders(): Promise<string>;
}
