import { TxType } from 'src/framework';
import { Company } from 'src/licitaapp/domain';
import { UserMinimalTO } from 'src/licitaapp/domain/dto/user.minimal.to';

export interface UserCompanyService {
  countUserByCompany(companyId: number): Promise<number>;
  saveUserCompany(
    userId: number,
    companyId: number,
    tx?: TxType,
  ): Promise<boolean>;
  findCompaniesByUserId(userId: number): Promise<Company[]>;
  paginationByUser(
    userId: number,
    page: number,
    pageSize: number,
  ): Promise<Company[]>;
  deleteByUserCompany(userId: number, companyId: number): Promise<void>;
  
  getUserIdsWithActiveCompany(): Promise<number[]>;
  getInfoUserCompany(companyId: number): Promise<UserMinimalTO[]>;
}
