import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { Company, Keyword } from '../';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';

class CompanyFullTO {
    @ApiPropertyOptional({
        description: 'Company fields user',
        type:() =>  Company,
    })
    public company: Company;
    @ApiProperty({
    description: 'Keywords user',
    type:() => [Keyword],
    })
    public listKeywords: Keyword[];
    @ApiProperty({
    description: 'Subdivisions user',
    type:() => [Subdivision],
    })
    public listSubdivisions: Subdivision[];
    constructor(company: Company, listKeywords: Keyword[], listSubdivisions: Subdivision[]) {
        this.company = company;
        this.listKeywords = listKeywords;
        this.listSubdivisions = listSubdivisions;
    }
}

export { CompanyFullTO };