import { ApiProperty } from '@nestjs/swagger';
import { AddCompanyKeyword, Company } from '../';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';


class CompanyRegisterTO {
  @ApiProperty({
    description: 'Company minimal fields',
    type: Company,
  })
  public company: Company;
  @ApiProperty({
    description: 'Keywords list user preferences',
    type: [AddCompanyKeyword],
  })
  public listKeywords: [AddCompanyKeyword];
  @ApiProperty({
    description: 'Subdivisions list user preferences',
    type: [Subdivision],
  })
  public listSubdivisions: [Subdivision];
}

export { CompanyRegisterTO };
