import { ApiProperty } from "@nestjs/swagger";

export class DashboardDetailTO {
    @ApiProperty({
      description: 'Type of money',
      example: 'CLP',
    })
    description: String;
    @ApiProperty({
      description: 'Amount of money',
      example: 1500000,
    })
    amountPerSubdivision: number;
    @ApiProperty({
      description: 'Amount of money with label',
      example: '1.5m',
    })
    labelAmount: String;

    @ApiProperty({
      description: 'Subdivision id',
      example: '19',
      required: false,
    })
    subdivisionId?: number | null;

    @ApiProperty({
      description: 'Date filter tender',
      example: '2021-01-01T00:00:00.000Z',
      required: false
    })
    dateFilterTender?: Date | null;

    count?: number;

    constructor(
      description: String,
      amountPerSubdivision: number,
      labelAmount: String,
      subdivisionId?: number | null,
      dateFilterTender?: Date | null,
      count: number = 0
    ) {
      this.description = description;
      this.amountPerSubdivision = amountPerSubdivision;
      this.labelAmount = labelAmount;
      this.subdivisionId = subdivisionId;
      this.count = count;
      this.dateFilterTender = dateFilterTender;
    }
}