import { ApiProperty } from "@nestjs/swagger";

class UserMinimalTO{
    @ApiProperty({
        description: 'User ID',
        example: 16,
        type: Number,
        required: true,
    })
    public userId: number;
    @ApiProperty({
        description: 'User full name',
        example: 'John Doe',
        type: String,
        required: true,
    })
    public fullName: string;
    @ApiProperty({
        description: 'User email',
        example: 'dsfdjksfh@gmail.com',
        type: String,
        required: true,
    })
    public email: string;
    @ApiProperty({
        description: 'User phone number',
        example: '+56912345678',
        type: String,
        required: true,
    })
    public phone: string;
    @ApiProperty({
        description: 'user active status',
        example: true,
        type: Boolean,
        required: true,
    })
    public active: boolean;

    constructor(userId: number, fullName: string, email: string, phone: string, active: boolean) {
        this.userId = userId;
        this.fullName = fullName;
        this.email = email;
        this.phone = phone;
        this.active = active;
    }
}

export { UserMinimalTO };