import { ApiProperty, OmitType } from '@nestjs/swagger';

class Company {
  @ApiProperty({
    description: 'Company id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Rut',
    example: '56.148.656-6',
  })
  dni: string;

  @ApiProperty({
    description: 'Social Reason',
    example: 'Empresa AMK SA',
  })
  socialReason: string;

  @ApiProperty({
    description: 'last modification date',
    example: '2021-06-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  updatedAt?: Date | null | undefined;

  constructor(id: number, dni: string, socialReason: string) {
    this.id = id;
    this.dni = dni;
    this.socialReason = socialReason;
  }
}

class InsertCompany extends OmitType(Company, ['id']) {}
class MinimalCompany extends OmitType(Company, ['updatedAt']) {}

export { Company, InsertCompany, MinimalCompany };
