import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework';
import { MercadoPublicoGirosModule } from 'src/licitaapp/application/mercado-publico/mp-giros/mp-giros.module';
import { KeywordController } from '../../controllers/keyword/keyword.controller';
import { KeywordServiceImpl } from '../../service/keyword-service-impl/keyword-service-impl';
import { KeywordRepositoryImpl } from '../../repository/keyword-repository-impl/keyword-repository-impl';
import { CompanyModule } from '../company/company.module';

@Module({
    imports: [forwardRef(() => DrizzleModule),MercadoPublicoGirosModule,forwardRef(() =>  CompanyModule)],
    controllers: [KeywordController],
    providers: [
        {
            provide: 'KeywordService',
            useClass: KeywordServiceImpl,
        },
        {
            provide: 'KeywordRepository',
            useClass: KeywordRepositoryImpl,
        },
    ],
    exports: [
        'KeywordService',
        'KeywordRepository',
    ],
})
export class KeywordModule {}
