import { forwardRef, Module } from '@nestjs/common';
import { UserCompanyTenderServiceImpl } from '../../service/user-company-tender-service-impl/user-company-tender-service-impl';
import { UserCompanyTenderRepositoryImpl } from '../../repository/user-company-tender-repository-impl/user-company-tender-repository-impl';
import { DrizzleModule } from 'src/framework';

@Module({
    imports: [forwardRef(() => DrizzleModule)],
    controllers: [],
    providers: [
        {
            provide: 'UserCompanyTenderService',
            useClass: UserCompanyTenderServiceImpl,
        },
        {
            provide: 'UserCompanyTenderRepository',
            useClass: UserCompanyTenderRepositoryImpl,
        },
    ],
    exports: [
        'UserCompanyTenderService',
        'UserCompanyTenderRepository',
    ],
})
export class UserCompanyTenderModule {}
