import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger, TxType } from 'src/framework';
import { ApplicationLogRepository } from 'src/licitaapp/application/repository/application-log-repository/application-log-repository.interface';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { ApplicationLog, InsertApplicationLog } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';

@Injectable()
export class ApplicationLogServiceImpl implements ApplicationLogService {
    private readonly LOGGER = new PrimeLogger(ApplicationLogServiceImpl.name);
    constructor(
        @Inject('ApplicationLogRepository') private readonly applicationLogRepository: ApplicationLogRepository
    ) {}
    save(applicationLog: InsertApplicationLog, tx?: TxType): Promise<number> {
        this.LOGGER.log(`save service: ${applicationLog}`);
        return this.applicationLogRepository.save(applicationLog, tx);
    }
    updateState(applicationLogId: number, statusTypeId: number, detail: string, tx?: TxType): Promise<boolean> {
        this.LOGGER.log(`updateState service: applicationLogId: ${applicationLogId}, statusTypeId: ${statusTypeId}, detail: ${detail}`);
        return this.applicationLogRepository.updateState(applicationLogId, statusTypeId, detail, tx);
    }
    logicalRemove(applicationLogId: number, tx?: TxType): Promise<boolean> {
        this.LOGGER.log(`logicalRemove service: applicationLogId: ${applicationLogId}`);
        return this.applicationLogRepository.logicalRemove(applicationLogId, tx);
    }
    getAllPaginated(page: number, pageSize: number, type?: ApplicationTypeEnum): Promise<ApplicationLog[]> {
        this.LOGGER.log(`getAllPaginated service: page: ${page}, pageSize: ${pageSize}, type: ${type}`);
        return this.applicationLogRepository.findAll(page, pageSize, type);
    }
    
}
