import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { HistoryTenderService } from 'src/licitaapp/application/service/history-tender-service/history-tender-service.interface';
import { HistoryTenderRepositoryImpl } from '../../repository/history-tender-repository-impl/history-tender-repository-impl';
import { HistoryTenderRepository } from 'src/licitaapp/application';
import { TenderTO } from 'src/licitaapp/domain';

@Injectable()
export class HistoryTenderServiceImpl implements HistoryTenderService {
  private readonly LOGGER = new PrimeLogger(HistoryTenderRepositoryImpl.name);
  constructor(
    @Inject('HistoryTenderRepository')
    private readonly historyTenderRepository: HistoryTenderRepository,
  ) {}
  erraseUserHistoryTender(tenderInfo: TenderTO): Promise<void> {
    this.LOGGER.log(`erraseUserHistoryTender - tenderId: ${tenderInfo.code}`);
    return this.historyTenderRepository.erraseUserHistoryTender(tenderInfo);
  }
  saveHistoryTender(userId: number, tenderId: number): void {
    this.LOGGER.log(
      `SaveHistoryTender - userId: ${userId}, tenderId: ${tenderId}`,
    );
    this.historyTenderRepository.save(userId, tenderId);
  }
  findByUserTender(userId: number, tenderId: number) {
    this.LOGGER.log(
      `findByUserTender - userId: ${userId}, tenderId: ${tenderId}`,
    );
    return this.historyTenderRepository.findByUserTender(userId, tenderId);
  }
  getListTenderHistory(userId: number) {
    this.LOGGER.log(`getListTenderHistory - userId: ${userId}`);
    return this.historyTenderRepository.getListTenderHistory(userId);
  }
}
