import { Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { MatchWordsService } from 'src/licitaapp/application/service/match-words-service/match-words-service.interface';

@Injectable()
export class MatchWordsServiceImpl implements MatchWordsService {
  private readonly LOGGER = new PrimeLogger(MatchWordsServiceImpl.name);
  findMatches(
    list1: string[],
    list2: string[],
  ): { item: string; matches: string[] }[] {
    this.LOGGER.debug(
      `findMatches list1 ${JSON.stringify(list1)} list2 ${JSON.stringify(
        list2,
      )}`,
    );
    const results = [];
    // Normalizar texto: convertir a minúsculas y eliminar caracteres especiales
    const normalizeText = (text: string): string =>
      text
        .toLowerCase()
        .normalize('NFD')
        .replace(/[\u0300-\u036f]/g, '')
        .replace(/[^a-z0-9 ]/g, '')
        .replace('de', '')
        .replace(' y ', '');

    // Crear una lista de palabras clave de la segunda lista
    const keywords = list2.map(normalizeText);

    for (const item of list1) {
      const normalizedItem = normalizeText(item);
      const itemWords = normalizedItem.split(' ');

      // Buscar coincidencias palabra por palabra
      const matches = keywords.filter((keyword) =>
        itemWords.some(
          (word) => keyword.includes(word) || word.includes(keyword),
        ),
      );

      results.push({ item, matches });
    }

    return results;
  }
}
